fn Description =
(
	"Convert to Arnold Compatible Features"
)

fn RenderPreset =
(
)

fn RendererClassID =
(
	#(0xb1a438deL, 0xa045667aL)
)

fn Setup =
(
	-- Conversion from mental ray Arch and Design to Physical Material
	SceneConverter.AddConversionRule #(0x70b05735L, 0x4a163654L) #(0x3d6b1cecL, 0xdeadc001L) conversionType:1
	-- Conversion from Autodesk Material to Physical Material
	SceneConverter.AddConversionRule #(0x1ed415e4L, 0x213daaf8L) #(0x3d6b1cecL, 0xdeadc001L) conversionType:1
	-- Conversion from Autodesk Bitmap to Bitmap Texture
	SceneConverter.AddConversionRule #(0x7ed417e4L, 0x273deef8L) #(0x240L, 0x0L) conversionType:1
	-- Conversion from mental ray Gamma and Gain to Color Map
	SceneConverter.AddConversionRule #(0x7773161fL, 0x996c7d15L) #(0x139f22c6L, 0x13f6a914L) conversionType:1
	-- Conversion from mental ray Physical Sky to Physical Sun & Sky
	SceneConverter.AddConversionRule #(0x628e269eL, 0x72386abfL) #(0x223349b4L, 0x562a7d8bL) conversionType:1
	-- Conversion from Free Camera to Physical Camera
	SceneConverter.AddConversionRule #(0x1001L, 0x0L) #(0x46697218L, 0x28e8008dL) conversionType:1
	-- Conversion from Target Camera to Physical Camera
	SceneConverter.AddConversionRule #(0x1002L, 0x0L) #(0x46697218L, 0x28e8008dL) conversionType:1
	-- Conversion from mental ray Photographic Exposure Control to Physical Camera Exposure Control
	SceneConverter.AddConversionRule #(0x73317331L, 0x49154663L) #(0x27964a9bL, 0x2ea5376aL) conversionType:1
	-- Conversion from mental ray Sun and Sky to Sun Positioner
	SceneConverter.AddConversionRule #(0x4a1e6debL, 0x31c77d57L) #(0x27fe329cL, 0x716f5b25L) conversionType:1
	-- Conversion from Standard Material to Physical Material
	SceneConverter.AddConversionRule #(0x2L, 0x0L) #(0x3d6b1cecL, 0xdeadc001L) conversionType:1
	-- Conversion from Missing Material to Physical Material
	SceneConverter.AddConversionRule #(0xffffffffL, 0x0L) #(0x3d6b1cecL, 0xdeadc001L) sourceAutodeskMaterialBaseType:"Missing Material" conversionType:2
	-- Remove from scene Missing Texmap
	SceneConverter.RemoveFromScene #(0xffffffffL, 0x0L) sourceAutodeskMaterialBaseType:"Missing Texmap"
	-- Conversion from Physical Material to Arnold Standard Surface [No Displacement]
	SceneConverter.AddConversionRule #(0x3d6b1cecL, 0xdeadc001L) #(0x7e73161fL, 0x62f74b4cL) scriptID:"No Displacement" conversionType:1
	-- Conversion from Photometric Free Light to Arnold Light
	SceneConverter.AddConversionRule #(0x32375fccL, 0xb025cf0L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Target Light to Arnold Light
	SceneConverter.AddConversionRule #(0x658d4f97L, 0x72cd4259L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Free Disc to Arnold Light
	SceneConverter.AddConversionRule #(0x5bcc6d42L, 0xc4f430eL) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Target Disc to Arnold Light
	SceneConverter.AddConversionRule #(0x38732348L, 0x201758b3L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Free Rectangle to Arnold Light
	SceneConverter.AddConversionRule #(0x36507d92L, 0x105a1a47L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Target Rectangle to Arnold Light
	SceneConverter.AddConversionRule #(0x71794f9dL, 0x70ae52f2L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Free Cyclinder to Arnold Light
	SceneConverter.AddConversionRule #(0x46f634e3L, 0xa327aafL) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Target Cylinder to Arnold Light
	SceneConverter.AddConversionRule #(0x7c8b5b10L, 0x4bd33e86L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Free Sphere to Arnold Light
	SceneConverter.AddConversionRule #(0x7ca93582L, 0x1abb6b32L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Target Sphere to Arnold Light
	SceneConverter.AddConversionRule #(0x33fc7ae9L, 0x54433dc5L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Free Line to Arnold Light
	SceneConverter.AddConversionRule #(0x78207401L, 0x357f1d58L) #(0x6705f00dL, 0xca131d05L) conversionType:1
	-- Conversion from Photometric Target Line to Arnold Light
	SceneConverter.AddConversionRule #(0x45076885L, 0x40791449L) #(0x6705f00dL, 0xca131d05L) conversionType:1
)

fn RemoveInvalidElementFromScene =
(
	TRUE
)

fn ScriptsIncludes =
(
	#()
)

fn PreConvert =
(
	--add here, as a string between double quotes, any Maxscript inscructions to apply before any conversion has started.
	"															
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	"
)

fn PostConvert =
(
	--add here, as a string between double quotes, any Maxscript inscructions to apply after all conversions have been applied.
	"															
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	"
)

